using System.Collections.Generic;
using HIPS.Client.Proxy;
using HIPS.CommonSchemas.Hi;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.ModelInterface.Hi;

namespace HIPS.Web.Data.Hips.Reference
{
    public class HiReferenceRepository : IHiReferenceRepository
    {
        private HiReferenceProxy proxy = new HiReferenceProxy("HiReferenceEndPoint");

        public List<HiSex> GetHiSexes()
        {
            return proxy.GetHiSexes();
        }

        public List<HiPostalDeliveryType> GetHiPostalDeliveryTypes()
        {
            return proxy.GetHiPostalDeliveryTypes();
        }

        public List<HiUnitType> GetHiUnitTypes()
        {
            return proxy.GetHiUnitTypes();
        }

        public List<HiLevelType> GetHiLevelTypes()
        {
            return proxy.GetHiLevelTypes();
        }

        public List<HiStreetType> GetHiStreetTypes()
        {
            return proxy.GetHiStreetTypes();
        }

        public List<HiStreetSuffixType> GetHiStreetSuffixTypes()
        {
            return proxy.GetHiStreetSuffixTypes();
        }

        public List<HiState> GetHiStates()
        {
            return proxy.GetHiStates();
        }

        public List<HiCountry> GetHiCountries()
        {
            return proxy.GetHiCountries();
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (proxy != null)
            {
                proxy.DisposeSafely();
                proxy = null;
            }
        }
    }
}
